
/* Metrowerks Standard Library
 * Copyright  1995-2001 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2002/11/14 10:14:53 $
 * $Revision: 1.1 $
 */
 

#ifndef _MSL_ANSI_PREFIX_WIN32_H
#define _MSL_ANSI_PREFIX_WIN32_H


#define WIN32		/* 2002-11-09 AR */
#define NDEBUG		/* 2002-11-09 AR */
#define _WINDOWS	/* 2002-11-09 AR */


#include <os_enum.h>
#define __dest_os	__win32_os
#include <x86_prefix.h>
#define _MT
#ifndef _MWMT
# define _MWMT 1 
#endif 
 /* need this to pick up prototypes for _begin/_endthreadex 
    in the win32 SDK header process.h */


#define STOP_PROGRAM_BEFORE_EXIT 0  /* will stop console apps from exiting
                                       before you get a chance to see it, set to 0 
                                       if you don't want this behavior

                                    */

/* hh 980121 Protect ourselves from overly helpful Microsoft headers */
#define _WCHAR_T_DEFINED
#define _SIZE_T_DEFINED

#define __MSL_LONGLONG_SUPPORT__
/* #define _MSL_MALLOC_0_RETURNS_NON_NULL */
/*
	Turn on _MSL_OS_DIRECT_MALLOC for a malloc alternative that simply goes
	straight to the OS with	no pooling.  Recompile the C lib when flipping
	this switch.  This will typically cause poorer performance, but may be of
	help when debugging memory problems. */
/* #define _MSL_OS_DIRECT_MALLOC */
/* #define _MSL_PRO4_MALLOC */
/* hh 980217 
	__ANSI_OVERLOAD__ controls whether or not the prototypes in the C++ standard
	section 26.5 get added to <cmath> and <math.h> or not.  If __ANSI_OVERLOAD__
	is defined, and a C++ compiler is used, then these functions are available,
	otherwise not.
	
	There is one exception to the above rule:  double abs(double); is available
	in <cmath> and <math.h> if the C++ compiler is used.  __ANSI_OVERLOAD__ has
	no effect on the availability of this one function.
	
	There is no need to recompile the C or C++ libs when this switch is flipped.
*/

/* Turn on and off namespace std here */
#if defined(__cplusplus) && __embedded_cplusplus == 0
    #define _MSL_USING_NAMESPACE
	/* Turn on support for wchar_t as a built in type */
	/* #pragma wchar_type on */   /*  vss  not implemented yet  */
#endif


#define __ANSI_OVERLOAD__ 		/*- hh 990201 -*/
#define _MSL_INTEGRAL_MATH
#define _POSIX 					/*- cc 000210 -*/



//#include <wchar_t.h>


#include <Win32Headers.h>		/* 2002-11-09 AR */


#endif /* _MSL_ANSI_PREFIX_WIN32_H */

/* Change record:
 * KO  960711 Added this include for the WinNT headers
 * bkoz960829 need to define modena lib for c++ libraries
 * hh  980121 Protect ourselves from overly helpful Microsoft headers by telling them that
 *            we will take care of the C lib.
 * mf  980621 added #define _MWMT          
 * hh  990201 turned __ANSI_OVERLOAD__ on because we now have foo(int) support
 * hh  990228 added _MSL_MALLOC_0_RETURNS_NON_NULL flag
 * mf  990301 yikes to the above ^, commented out STOP_PROGRAM_BEFORE_EXIT to attempt new scheme
 *            w/Pro 5 ide, also added logic for single threaded lib.
 * mf  990309 use _MWMT instead of _MT for single threaded lib             
 * blc 990408 turned off STOP_PROGRAM_BEFORE_EXIT; not needed with Pro5 IDE
 * hh  000302 Moved the namespace flag to here from mslGlobals.h
 * cc  000315 added _MSL_IMP_EXP  
 * cc  000316 removed  _MSL_IMP_EXP  
 */